
//+++++++++++++++++++++++++++++++++++++++
//
//Diffraction of Infra-Red Edge Radiation on a Rectangular Aperture
//
//+++++++++++++++++++++++++++++++++++++++
proc SrwExamDiffrER()

srwUtiShowHelpTopic("Diffraction of Infra-Red Edge Radiation     ")

Print "Computing the Diffraction of Infra-Red Edge Radiation. Be patient."

variable t0=stopmstimer(0)
t0=startmstimer
SrwUtiTriggerPrint(2)

// Initialization
SrwInit(2)

// Create Electron Beam
SrwElecFilament("SOL",2.5,0.5,0,0,0,0,0)

// Create Magnetic Field
SrwMagFieldCreate("Edge",0,6,1000)
SrwMagEdge("EdgeBZ_fld",1,0,5,50,1.56)

SrwMagDisplayField("EdgeBZ_fld")

// Setup Longitudinal Integration parameters
SrwMagPrec("Edge_mag",3,0.01,0.1,10000,1,-3,3)

// Create Radiation Sampling
SrwSmpCreate("O",3.2)

Variable Ax = 20 // [mm]; This is the horizontal size of the Rect. Aperture
Variable Az = 10 // [mm]; This is the vertical size of the Rect. Aperture
Variable PhotonEnergy = 1.e-05 // [keV]
SrwSmpScanXZE("O_obs",0,Ax,2,0,Az,2,PhotonEnergy,PhotonEnergy,1)

// Compute the ER within the Aperture, in the mode suitable for further propagation
SrwWfrCreate("W","SOL_ebm","Edge_mag","O_obs",2,2.5)

// Visualize the ER Intensity at the Aperture
SrwWfrResize("W_rad",1,3,3,3,3,2,"Aux") // This is to better visualize only! Not for propagation!
SrwWfr2Int("Aux_rad","I",7,1,4,1,1e-05,0,0,2)
Textbox/N=text0/F=0 "\\Z07 Spectral Flux / Surface \r on the Aperture \r 0.7 m from downstream BM edge \r Wavelength : 124 m "

SrwWfr2Int("Aux_rad","I",7,1,2,1,1e-05,0,0,2)
Textbox/N=text0/F=0 "\\Z07 Spectral Flux / Surface \r on the Aperture \r (horizontal profile) \r 0.7 m from downstr. BM edge \r Wavelength : 124 m "
ModifyGraph mode=2,lsize=1.1

// Create a Drift Space of 5 m length 
SrwOptDrift("Drift",5)

// Resize the SR Wavefront in order to check/increase the accuracy of propagation
SrwWfrResize("W_rad",1,1,1.2,1,1,2,"Wd")

// Propagate the ER Wavefront through the (Aperture and) Drift Space
SrwWfrPropagate("Wd_rad","Drift_bli",1,1,"")

// Visualize the Intensity of the propagated radiation
SrwWfrResize("Wd_rad",1,0.5,1,0.5,1,1,"") // This is to better visualize only! Not for propagation!
SrwWfr2Int("Wd_rad","I",7,1,2,1,1e-05,0,0,2)
Textbox/N=text0/F=0 "\\Z07 Spectral Flux / Surface \r after propagation \r (horizontal profile) \r 5 m from the Aperture \r Wavelength : 124 m "
ModifyGraph mode=2,lsize=1.1

SrwWfr2Int("Wd_rad","IProp",7,1,4,1,1e-05,0,0,2)
Textbox/N=text0/F=0 "\\Z07 Spectral Flux / Surface \r after propagation \r 5 m from the Aperture \r Wavelength : 124 m "

TileWindows/O=1/C

srwUtiShowHelpTopic("Diffraction of Infra-Red Edge Radiation     ")

print "CPU Time : ",srround(stopmstimer(t0)/1e6,1)," seconds"
SrwUtiTriggerPrint(1)

print " "
print "The macro generating this computation can be found in the file \"SRW Example ER Diffraction.ipf\""
print "that can be accessed through the menu \"Windows->Procedure Windows\" (assuming IGOR Pro version 6 or higher)"

end
